/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: cifXTestDlg.cpp $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 29.10.09 12:47 $
    $Revision: 3160 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Main cifX Test dialog
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      3        07.05.2008  DB       Fixed:
                                      - crash when closeing the App and a device was open. 
                                    Reason:
                                      - firt close the App the Driver (xDriverClose) and than the Channel (xChannelClose).
      2        10.07.2007  MT       Fixed:
                                      - crash when no device was selected during Open Device
      1        28.06.2006  MT       initial version
 
**************************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
/// \file CifxTestDlg.h
///  Main cifX Test dialog
///////////////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cifXTest.h"
#include "cifXTestDlg.h"
#include "cifxuser.h"
#include "CifxErrors.h"
#include "CifxDeviceOpenDlg.h"
#include "CifXDeviceBase.h"
#include "BaseDialog.h"
#include "verinfo.h"
#include ".\cifxtestdlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

CCifXDeviceBase* CcifXTestDlg::s_pcDevice = NULL;

static UINT s_auiStatusBarPanes[] =
{
  ID_STATUSBAR_PANE,
};

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialogfelddaten
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung

// Implementierung
protected:
	DECLARE_MESSAGE_MAP()
public:
  virtual BOOL OnInitDialog();
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()

BOOL CAboutDlg::OnInitDialog()
{
  CDialog::OnInitDialog();

  CFileVersionInfo cVerInfo;
  cVerInfo.Open(AfxGetApp()->m_hInstance);

  TCHAR szData[MAX_PATH] = {0};
  //query product name
  if(cVerInfo.QueryStringValue(VI_STR_PRODUCTNAME, szData, sizeof(szData)/sizeof(TCHAR)))
    SetDlgItemText(IDC_STATIC_PROGRAMNAME, szData);
  else
    SetDlgItemText(IDC_STATIC_PROGRAMNAME, NULL);

  if(cVerInfo.QueryStringValue(VI_STR_COMPANYNAME, szData, sizeof(szData)/sizeof(TCHAR)))
    SetDlgItemText(IDC_STATIC_COMPANYNAME, szData);
  else
    SetDlgItemText(IDC_STATIC_COMPANYNAME, NULL);

  if(cVerInfo.QueryStringValue(VI_STR_FILEVERSION, szData, sizeof(szData)/sizeof(TCHAR)))
    SetDlgItemText(IDC_STATIC_VERSION, szData);
  else
    SetDlgItemText(IDC_STATIC_VERSION, NULL);
  
  if(cVerInfo.QueryStringValue(VI_STR_LEGALCOPYRIGHT, szData, sizeof(szData)/sizeof(TCHAR)))
    SetDlgItemText(IDC_STATIC_COPYRIGHT, szData);
  else
    SetDlgItemText(IDC_STATIC_COPYRIGHT, NULL);

  return TRUE;  // return TRUE unless you set the focus to a control
  // EXCEPTION: OCX Property Pages should return FALSE
}


/////////////////////////////////////////////////////////////////////////////
/// Default Constructor
///   \param pParent Parent window
/////////////////////////////////////////////////////////////////////////////
CcifXTestDlg::CcifXTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CcifXTestDlg::IDD, pParent)
  , m_hCifxDriver(NULL)
  , m_pcActualDlg(NULL)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

/////////////////////////////////////////////////////////////////////////////
/// DDX/DDV support
///   \param pDX 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CcifXTestDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
  ON_COMMAND(ID_FILE_QUIT, OnFileQuit)
  ON_WM_DESTROY()
  ON_COMMAND(ID_DEVICE_OPEN, OnDeviceOpen)
	ON_WM_INITMENUPOPUP()
  ON_UPDATE_COMMAND_UI(ID_DEVICE_CLOSE, OnUpdateDeviceClose)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_RESET, OnUpdateDeviceReset)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_WATCHDOG, OnUpdateDeviceWatchdog)
  ON_UPDATE_COMMAND_UI(ID_DATATRANSFER_PACKETDATA, OnUpdateDatatransferPacketdata)
  ON_UPDATE_COMMAND_UI(ID_DATATRANSFER_I, OnUpdateDatatransferI)
  ON_COMMAND(ID_DEVICE_CLOSE, OnDeviceClose)
  ON_COMMAND(ID_DATATRANSFER_PACKETDATA, OnDatatransferPacketdata)
  ON_COMMAND(ID_DATATRANSFER_I, OnDatatransferI)
  ON_COMMAND(ID__ABOUT, OnHelpAbout)
  ON_COMMAND(ID_INFORMATION_DRIVERINFORMATION, OnInformationDriverinformation)
  ON_UPDATE_COMMAND_UI(ID_INFORMATION_CHANNELINFORMATION, OnUpdateInformationChannelinformation)
  ON_COMMAND(ID_INFORMATION_CHANNELINFORMATION, OnInformationChannelinformation)
  ON_COMMAND(ID_DEVICE_WATCHDOG, OnDeviceWatchdog)
  ON_COMMAND(ID_DEVICE_HOSTSTATE, OnDeviceHoststate)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_HOSTSTATE, OnUpdateDeviceHoststate)
  ON_COMMAND(ID_DEVICE_BUSSTATE, OnDeviceBusstate)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_BUSSTATE, OnUpdateDeviceBusstate)
  ON_COMMAND(ID_DEVICE_DMASTATE, OnDeviceDMAstate)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_DMASTATE, OnUpdateDeviceDMAstate)
  ON_COMMAND(ID_DEVICE_DOWNLOAD, OnDeviceDownload)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_DOWNLOAD, OnUpdateDeviceDownload)
  ON_COMMAND(ID_INFORMATION_MAILBOXSTATE, OnInformationMailboxstate)
  ON_UPDATE_COMMAND_UI(ID_INFORMATION_MAILBOXSTATE, OnUpdateInformationMailboxstate)
  ON_COMMAND(ID_DEVICE_RESET, OnDeviceReset)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_OPEN, OnUpdateDeviceOpen)
  ON_UPDATE_COMMAND_UI(ID_INFORMATION_DRIVERINFORMATION, OnUpdateInformationDriverinformation)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_CONFIGLOCK, OnUpdateDeviceConfiglock)
  ON_COMMAND(ID_DEVICE_CONFIGLOCK, OnDeviceConfiglock)
  ON_COMMAND(ID_DEVICE_FILEEXPLORER, OnDeviceFileexplorer)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_FILEEXPLORER, OnUpdateDeviceFileexplorer)
  ON_COMMAND(ID_DATATRANSFER_EXTENDEDMEMORY, &CcifXTestDlg::OnDatatransferExtendedmemory)
  ON_UPDATE_COMMAND_UI(ID_DATATRANSFER_EXTENDEDMEMORY, &CcifXTestDlg::OnUpdateDatatransferExtendedmemory)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
/// First time dialog initialization
///   \return TRUE
/////////////////////////////////////////////////////////////////////////////
BOOL CcifXTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

  m_cPacketDlg.Create(CPacketDlg::IDD, this);
  m_cIoDlg.Create(CIOAccessDlg::IDD, this);
  m_cInfoDialog.Create(CInformationDialog::IDD, this);
  m_cWatchdogDlg.Create(CWatchdogDlg::IDD, this);
  m_cHostStateDlg.Create(CHostStateDlg::IDD, this);
  m_cBusStateDlg.Create(CBusStateDlg::IDD, this);
  m_cDMAStateDlg.Create(CDMAStateDlg::IDD, this);
  m_cDownloadDlg.Create(CDownloadDlg::IDD, this);
  m_cMailboxStateDlg.Create(CMailboxStateDlg::IDD, this);
  m_cResetDlg.Create(CResetDlg::IDD, this);
  m_cConfigLockDlg.Create(CConfigLockDlg::IDD, this);
  m_cFileExplorerDlg.Create(CFileExplorerDlg::IDD, this);
  m_cExtendedMemoryDlg.Create(CExtendedMemoryDialog::IDD, this);

	// IDM_ABOUTBOX muss sich im Bereich der Systembefehle befinden.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Symbol fr dieses Dialogfeld festlegen. Wird automatisch erledigt
	//  wenn das Hauptfenster der Anwendung kein Dialogfeld ist
	SetIcon(m_hIcon, TRUE);			// Groes Symbol verwenden
	SetIcon(m_hIcon, FALSE);		// Kleines Symbol verwenden

  m_cStatusBar.Create(this);
  m_cStatusBar.SetIndicators(s_auiStatusBarPanes, sizeof(s_auiStatusBarPanes) / sizeof(s_auiStatusBarPanes[0]));

  CRect rectWindow;
  GetWindowRect(rectWindow);

  m_cStatusBar.SetPaneInfo(0, ID_STATUSBAR_PANE, SBPS_NORMAL, rectWindow.Width());

  long lRet = xDriverOpen(&m_hCifxDriver);

  if(CIFX_NO_ERROR == lRet)
    m_cStatusBar.SetPaneText(0, _T("Driver was successfully opened!"));
  else
  {   
    char szErrorDescr[MAX_PATH] = {0};
    xDriverGetErrorDescription(lRet, szErrorDescr, sizeof(szErrorDescr));

    CString csError;
    csError.Format(_T("Error opening driver! Error=0x%08X, '%s'!"), lRet, szErrorDescr);
    m_cStatusBar.SetPaneText(0, csError);
    
  }

  RepositionBars(AFX_IDW_CONTROLBAR_FIRST, AFX_IDW_CONTROLBAR_LAST, ID_STATUSBAR_PANE);

	return TRUE;  // Geben Sie TRUE zurck, auer ein Steuerelement soll den Fokus erhalten
}

/////////////////////////////////////////////////////////////////////////////
///
///   \param nID 
///   \param lParam 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

/////////////////////////////////////////////////////////////////////////////
/// WM_PAINT message handler (support for minimized windows)
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // Gertekontext zum Zeichnen

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Symbol in Clientrechteck zentrieren
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Symbol zeichnen
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

/////////////////////////////////////////////////////////////////////////////
/// Returns the cursor that is to be used, when dragging minimized windows
///   \return Handle to usable cursor
/////////////////////////////////////////////////////////////////////////////
HCURSOR CcifXTestDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

/////////////////////////////////////////////////////////////////////////////
/// Filter messages to prevent dialog closing by keypress
/// (WM_KEYDOWN combined with VK_RETURN/VK_ESCAPE) will be filtered
///  \param pMsg Message to be checked for filtering
///  \return TRUE if the message should be filtered 
/////////////////////////////////////////////////////////////////////////////
BOOL CcifXTestDlg::PreTranslateMessage(MSG* pMsg)
{
  if(pMsg->message == WM_KEYDOWN)
  {
    if( (pMsg->wParam == VK_RETURN) ||
        (pMsg->wParam == VK_ESCAPE) )
    {
      return TRUE;
    }
  }

  return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu File/Quit event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnFileQuit()
{
  EndDialog(0);
}

/////////////////////////////////////////////////////////////////////////////
/// Dialog is being destroyed
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDestroy()
{
  CDialog::OnDestroy();

  SetActiveDialog(NULL);

  if(NULL != s_pcDevice)
  {
    delete s_pcDevice;
    s_pcDevice = NULL;
  }
  
  if(NULL != m_hCifxDriver)
  {
    xDriverClose(m_hCifxDriver);
  }
}

/////////////////////////////////////////////////////////////////////////////
/// Menu Device/Open event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceOpen()
{
  CCifxDeviceOpenDlg cDlg;
  if(cDlg.DoModal() == IDOK)
  {
    SetActiveDialog(NULL);

    if(NULL != s_pcDevice)
    {
      delete s_pcDevice;
      s_pcDevice = NULL;        
    }

    if(NULL != (s_pcDevice = cDlg.GetSelectedDevice()))
    {
      long lRet = s_pcDevice->OpenDevice();

      if(lRet != CIFX_NO_ERROR)
      {
        CString csError;
        csError.Format(_T("Error opening device '%s'. Error=0x%08X, ('%s')!"),
                      s_pcDevice->GetDeviceName(), lRet, s_pcDevice->GetErrorDescription(lRet));
        AfxMessageBox(csError, MB_ICONERROR);    
        m_cStatusBar.SetPaneText(0, csError);

        delete s_pcDevice;
        s_pcDevice = NULL;
      } else
      {
        CString csCaption;
        csCaption.LoadString(IDS_CAPTION_MAINWND);
        csCaption.AppendFormat(_T(" - %s"), s_pcDevice->GetDeviceName());
        SetWindowText(csCaption);
        if(NULL != m_pcActualDlg)
          m_pcActualDlg->OnUpdateDevice(s_pcDevice);
      }
    } else
    {
      ASSERT(FALSE);
    }
  }
}

/////////////////////////////////////////////////////////////////////////////
/// Menu Device/Close event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceClose()
{
  SetActiveDialog(NULL);
  
  delete s_pcDevice;
  s_pcDevice = NULL;

  CString csCaption;
  csCaption.LoadString(IDS_CAPTION_MAINWND);
  SetWindowText(csCaption);
}

/////////////////////////////////////////////////////////////////////////////
///  Fix for UPDATE_COMMAND_UI messages not properly being handled in Dialog
///
///   \param *pPopupMenu 
///   \param nIndex 
///   \param bSysMenu 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnInitMenuPopup(CMenu *pPopupMenu, UINT /*nIndex*/,BOOL /*bSysMenu*/)
{
  ASSERT(pPopupMenu != NULL);
  // Check the enabled state of various menu items.

  CCmdUI state;
  state.m_pMenu = pPopupMenu;
  ASSERT(state.m_pOther == NULL);
  ASSERT(state.m_pParentMenu == NULL);

  // Determine if menu is popup in top-level menu and set m_pOther to
  // it if so (m_pParentMenu == NULL indicates that it is secondary popup).
  HMENU hParentMenu;
  if (AfxGetThreadState()->m_hTrackingMenu == pPopupMenu->m_hMenu)
    state.m_pParentMenu = pPopupMenu;    // Parent == child for tracking popup.
  else if ((hParentMenu = ::GetMenu(m_hWnd)) != NULL)
  {
    CWnd* pParent = this;
    // Child windows don't have menus--need to go to the top!
    if (pParent != NULL &&
      (hParentMenu = ::GetMenu(pParent->m_hWnd)) != NULL)
    {
      int nIndexMax = ::GetMenuItemCount(hParentMenu);
      for (int nIndex = 0; nIndex < nIndexMax; nIndex++)
      {
        if (::GetSubMenu(hParentMenu, nIndex) == pPopupMenu->m_hMenu)
        {
          // When popup is found, m_pParentMenu is containing menu.
          state.m_pParentMenu = CMenu::FromHandle(hParentMenu);
          break;
        }
      }
    }
  }

  state.m_nIndexMax = pPopupMenu->GetMenuItemCount();
  for (state.m_nIndex = 0; state.m_nIndex < state.m_nIndexMax;
    state.m_nIndex++)
  {
    state.m_nID = pPopupMenu->GetMenuItemID(state.m_nIndex);
    if (state.m_nID == 0)
      continue; // Menu separator or invalid cmd - ignore it.

    ASSERT(state.m_pOther == NULL);
    ASSERT(state.m_pMenu != NULL);
    if (state.m_nID == (UINT)-1)
    {
      // Possibly a popup menu, route to first item of that popup.
      state.m_pSubMenu = pPopupMenu->GetSubMenu(state.m_nIndex);
      if (state.m_pSubMenu == NULL ||
        (state.m_nID = state.m_pSubMenu->GetMenuItemID(0)) == 0 ||
        state.m_nID == (UINT)-1)
      {
        continue;       // First item of popup can't be routed to.
      }
      state.DoUpdate(this, TRUE);   // Popups are never auto disabled.
    }
    else
    {
      // Normal menu item.
      // Auto enable/disable if frame window has m_bAutoMenuEnable
      // set and command is _not_ a system command.
      state.m_pSubMenu = NULL;
      state.DoUpdate(this, FALSE);
    }

    // Adjust for menu deletions and additions.
    UINT nCount = pPopupMenu->GetMenuItemCount();
    if (nCount < state.m_nIndexMax)
    {
      state.m_nIndex -= (state.m_nIndexMax - nCount);
      while (state.m_nIndex < nCount &&
        pPopupMenu->GetMenuItemID(state.m_nIndex) == state.m_nID)
      {
        state.m_nIndex++;
      }
    }
    state.m_nIndexMax = nCount;
  }
}


/////////////////////////////////////////////////////////////////////////////
/// Checks if Device/Close menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceClose(CCmdUI *pCmdUI)
{
  if(s_pcDevice)
    pCmdUI->Enable();
  else
    pCmdUI->Enable(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if Device/Watchdog menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceWatchdog(CCmdUI *pCmdUI)
{
  if( (NULL == s_pcDevice) || s_pcDevice->IsSystemDevice())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if "Data Transfer/Packet data" menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDatatransferPacketdata(CCmdUI *pCmdUI)
{
  if(s_pcDevice)
    pCmdUI->Enable();
  else
    pCmdUI->Enable(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if "Data Transfer/I/OData" menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDatatransferI(CCmdUI *pCmdUI)
{
  if( (NULL == s_pcDevice) || s_pcDevice->IsSystemDevice())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Switches the display to the given Dialog
///   \param pcNewDialog Dialog to display
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::SetActiveDialog(CBaseDialog* pcNewDialog)
{
  CRect rectPlaceHolder;
  GetDlgItem(IDC_STATIC_PLACEHOLDER)->GetWindowRect(rectPlaceHolder);

  if(m_pcActualDlg)
  {
    m_pcActualDlg->ShowWindow(FALSE);
    m_pcActualDlg->SetThreadState(false);
    m_pcActualDlg->OnUpdateDevice(NULL);
    m_pcActualDlg = NULL;
  }

  ScreenToClient(rectPlaceHolder);

  m_pcActualDlg = pcNewDialog;

  if(NULL != m_pcActualDlg)
  {
    m_pcActualDlg->SetWindowPos(NULL, 
                                rectPlaceHolder.left,
                                rectPlaceHolder.top,
                                rectPlaceHolder.Width(),
                                rectPlaceHolder.Height(),
                                SWP_SHOWWINDOW | SWP_NOZORDER);

    m_pcActualDlg->OnUpdateDevice(s_pcDevice);
    m_pcActualDlg->SetThreadState(true);
  }
  
}

/////////////////////////////////////////////////////////////////////////////
/// Menu "Data Transfer/Packet Data" item clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDatatransferPacketdata()
{
  SetActiveDialog(&m_cPacketDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu "Data Transfer/I/O Data" item clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDatatransferI()
{
  SetActiveDialog(&m_cIoDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu "?/About" item clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnHelpAbout()
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu "Information/Driver Information" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnInformationDriverinformation()
{
  m_cInfoDialog.SetType(CInformationDialog::eDRIVERINFO);

  SetActiveDialog(&m_cInfoDialog);

  m_cInfoDialog.UpdateValues();
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if "Information/Driver Information" menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateInformationChannelinformation(CCmdUI *pCmdUI)
{
  if(s_pcDevice)
    pCmdUI->Enable();
  else
    pCmdUI->Enable(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu "Information/Channel Information" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnInformationChannelinformation()
{
  m_cInfoDialog.SetCaption(s_pcDevice->GetChannelInfoName());
  m_cInfoDialog.SetType(CInformationDialog::eCHANNELINFO);

  SetActiveDialog(&m_cInfoDialog);

  m_cInfoDialog.UpdateValues();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu "Device/Watchdog" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceWatchdog()
{
  SetActiveDialog(&m_cWatchdogDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu "Device/Host State" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceHoststate()
{
  SetActiveDialog(&m_cHostStateDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if "Device/Host State" menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceHoststate(CCmdUI *pCmdUI)
{
  if( (NULL == s_pcDevice) || s_pcDevice->IsSystemDevice())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu "Device/Bus State" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceBusstate()
{
  SetActiveDialog(&m_cBusStateDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if "Device/Bus State" menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceBusstate(CCmdUI *pCmdUI)
{
  if( (NULL == s_pcDevice) || s_pcDevice->IsSystemDevice())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu "Device/DMA State" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceDMAstate()
{
  SetActiveDialog(&m_cDMAStateDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if "Device/DMA State" menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceDMAstate(CCmdUI *pCmdUI)
{
  if( (NULL == s_pcDevice) || s_pcDevice->IsSystemDevice())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu "Device/Download" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceDownload()
{
  SetActiveDialog(&m_cDownloadDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if "Device/Download" menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceDownload(CCmdUI *pCmdUI)
{
  if(NULL == s_pcDevice)
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu "Information/Mailbox State" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnInformationMailboxstate()
{
  SetActiveDialog(&m_cMailboxStateDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if "Information/Mailbox State" menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateInformationMailboxstate(CCmdUI *pCmdUI)
{
  if(NULL == s_pcDevice)
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if Device/Reset menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceReset(CCmdUI *pCmdUI)
{
  if(s_pcDevice)
    pCmdUI->Enable();
  else
    pCmdUI->Enable(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu "Device/Reset" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceReset()
{
  SetActiveDialog(&m_cResetDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if Device/Open menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceOpen(CCmdUI *pCmdUI)
{
  //don't allow opening a Device if the driver is not available
  if(NULL == m_hCifxDriver)
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if "Information/Driver Information" menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateInformationDriverinformation(CCmdUI *pCmdUI)
{
  //don't allow querying driver information if the driver is not available
  if(NULL == m_hCifxDriver)
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if "Device/Config Lock" menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceConfiglock(CCmdUI *pCmdUI)
{
  if( (NULL == s_pcDevice) || s_pcDevice->IsSystemDevice())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Opens the Config lock dialog
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceConfiglock()
{
  SetActiveDialog(&m_cConfigLockDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Opens the File explorer dialog
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceFileexplorer()
{
  SetActiveDialog(&m_cFileExplorerDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if "Device/File Explorer" menu item is available
///   \param *pCmdUI 
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceFileexplorer(CCmdUI *pCmdUI)
{
  if(NULL == s_pcDevice)
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

void CcifXTestDlg::OnDatatransferExtendedmemory()
{
  SetActiveDialog(&m_cExtendedMemoryDlg);
}

void CcifXTestDlg::OnUpdateDatatransferExtendedmemory(CCmdUI *pCmdUI)
{
  if( (NULL == s_pcDevice) || !s_pcDevice->IsSystemDevice())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}
